/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.client.ArmorModelHelper;

public class TravelersGearModel
extends Model {
    private static final Map<ResourceLocation, TravelersGearModel> MODELS = new HashMap<ResourceLocation, TravelersGearModel>();
    private static final Function<ResourceLocation, TravelersGearModel> CONSTRUCTOR = TravelersGearModel::new;
    private static final ResourceLocation TRAVELERS = TConstruct.getResource("travelers");
    private final ResourceLocation overlayArmor;
    private final ResourceLocation overlayLegs;
    @Nullable
    private HumanoidModel<?> base;
    private boolean forceOverlay = false;
    private int color = -1;
    private boolean isLegs = false;
    private boolean hasGlint = false;

    public static Model getModel(ItemStack stack, EquipmentSlot slot, HumanoidModel<?> baseModel, ResourceLocation name, boolean forceOverlay) {
        TravelersGearModel model = MODELS.computeIfAbsent(name, CONSTRUCTOR);
        model.setup(baseModel, stack, slot, forceOverlay);
        return model;
    }

    public static Model getModel(ItemStack stack, EquipmentSlot slot, HumanoidModel<?> baseModel) {
        return TravelersGearModel.getModel(stack, slot, baseModel, TRAVELERS, false);
    }

    public TravelersGearModel(ResourceLocation name) {
        super(RenderType::m_110458_);
        this.overlayArmor = new ResourceLocation(name.m_135827_(), "textures/models/armor/" + name.m_135815_() + "_overlay_1.png");
        this.overlayLegs = new ResourceLocation(name.m_135827_(), "textures/models/armor/" + name.m_135815_() + "_overlay_2.png");
    }

    public void m_7695_(PoseStack matrices, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.base != null) {
            this.base.m_7695_(matrices, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            if ((this.forceOverlay || this.color != -1) && ArmorModelHelper.buffer != null) {
                float newRed = (float)(this.color >> 16 & 0xFF) / 255.0f;
                float newGreen = (float)(this.color >> 8 & 0xFF) / 255.0f;
                float newBlue = (float)(this.color & 0xFF) / 255.0f;
                VertexConsumer overlayBuffer = ItemRenderer.m_115184_((MultiBufferSource)ArmorModelHelper.buffer, (RenderType)RenderType.m_110464_((ResourceLocation)(this.isLegs ? this.overlayLegs : this.overlayArmor)), (boolean)false, (boolean)this.hasGlint);
                this.base.m_7695_(matrices, overlayBuffer, packedLightIn, packedOverlayIn, red * newRed, green * newGreen, blue * newBlue, alpha);
            }
        }
    }

    private void setup(HumanoidModel<?> base, ItemStack stack, EquipmentSlot slot, boolean forceOverlay) {
        this.base = base;
        this.forceOverlay = forceOverlay;
        this.color = ModifierUtil.getPersistentInt(stack, TinkerModifiers.dyed.getId(), -1);
        this.isLegs = slot == EquipmentSlot.LEGS;
        this.hasGlint = stack.m_41790_();
    }
}

